-- Fichero Call.sql
----------------------------------------------------------------------------
-- Bloque PL/SQL que ejecuta una llamada a la funcin FSQL2SQL,           --
-- para pasar una consulta FSQL a SQL estndar                            --
----------------------------------------------------------------------------
set serveroutput on size 3000
--create or replace PROCEDURE CALL IS
DECLARE
  consulta    LONG;
  Num_Errores INTEGER;
  CURSOR errores IS SELECT * FROM FSQL_ERRORS
                    WHERE SESSIONID=USERENV('SESSIONID')
                    ORDER BY INDICE;
  -- Cursor para formar la sentencia final:
  CURSOR query IS SELECT atributo FROM FSQL_QUERY
                  WHERE atributo IS NOT NULL AND SESSIONID=USERENV('SESSIONID')
                  ORDER BY INDICE;
BEGIN
--  EJEMPLOS DE CONSULTAS que se pueden efectuar al SFSQL:
--  consulta:='select * from dual');
--  consulta:='select algo.* from dual,x t where -a=+3.e-234;');
--  consulta:='(select CDEG(asd),dkfj.* from dual) UNION ALL (select * from no where a>3);');
--  consulta:='select x from tablas where x<y and y<z or y<=f;');
--  consulta:='select % from dual where dfs IS unknown and sdfs FEQ undefined <= .4 or not sdf FGEQ $[3,4,5,6];');
--  consulta:='select decode(a,b,c),cdeg(x) "cade",44 alias from tabla.xdf where x is not unknown and not algo is undefined or not joven is null and (a>=b or c FGEQ $joven .5);');
--  consulta:='((select max(a),c "alias1", d alias, CDEG(x)+3 from loco x,t2 tt2
--           where ($joven fgeq #4 thold .5 or $[4,5,6,7.1e+3] fleq [2,6] .3)
--                 and columna.algo feq NULL)
--          INTERSECT (select * from f))
--          UNION ALL (select a,CDEG(ad) from w where c1 is unknown and c2 is not undefined)
--          ORDER BY a,b,c DESC, x ASC';
--  consulta:='select a from tabla.xdf where x is not unknown and not algo is undefined or not joven is null and (a>=b or c FGEQ $joven .5);');
--  consulta:='select a from (select a from b) where x is null AND Y=(A + MAX(Z)/(A>b))');
--  consulta:='select {a} X,(Z FEQ U THOLD .3) z from W WHERE {Z}<Y AND E FGEQ $JOVEN <= .5');
--  consulta:='(select a Z from W WHERE {Z <Y} AND ($[3,4,5,6] FGEQ XX < .4E-5))');
--                    10        20        30        40        50        60        70        80        90        100       110       120       130       140       150
--           123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 12345
--  consulta:='select a.b.c, e.f h, w, CDEG(r.t.y) kk, (rowid) from x.y where #3 feq $x';
--  consulta:='select a FROM X where (5 feq $x) AND X FGT #4';
--  consulta:='select a FROM X where (x feq #4)';

--  consulta:='select estudios ,experiencia,cdeg(aptitud.experiencia)+2, scott.aptitud.experiencia from aptitud';
--  consulta:='select estudios from aptitud where experiencia FEQ #3 THOLD 3 and experiencia FGT #234 <= .3 or 3+aptitud.experiencia FGEQ #2 and experiencia fgt #2 .43';
--  consulta:='select estudios from aptitud where experiencia FEQ [3,4] THOLD 3 and experiencia FGT [234,2342] <= .3 or 3+aptitud.experiencia FGEQ [234,4] and estudios fgt [2,.43]';
--  consulta:='select estudios from aptitud where
--             experiencia FEQ $[3,4,5,6] THOLD 3 and
--             experiencia FGT $[234,2342,6,8] <= .3 or
--             3+aptitud.experiencia FGEQ $[2,3453,34,4] 111111
--             and experiencia fgt $[2,.43,345,32345]';
--  consulta:='select estudios from aptitud where
--             (experiencia FEQ aptitud.EXPERIENCIA THOLD 3) and
--             ((experiencia FGT APTITUD.EXPERIENCIA <= .3) or
--             3+aptitud.experiencia FGEQ EXPERIENCIA+5 45) and
--             (experiencia fgt PPGG.APTITUD.EXPERIENCIA)';
--  consulta:='select estudios from aptitud where
--             experiencia FEQ aptitud.experiencia THOLD 3 and
--             experiencia FGT aptitud.experiencia <= .3 or
--             3+experiencia FGEQ scott.aptitud.experiencia-5 and
--             aptitud.experiencia fgt 4 .5';
--  consulta:='select estudios, prof '||CHR(34)||'profes.'||CHR(34)||',experiencia from aptitud';
--  consulta:='select experiencia from aptitud where
--             (experiencia is NOT UNDEFINED) AND experiencia IS NOT unknown or NOT (APTITUD.ESTUDIOS IS NOT NULL)';
--  consulta:='select clave,estudios from requisitos,aptitud where requisitos.estudios FeQ sqrt(6) THOLD 0';
--  consulta:='select clave,requisitos.estudios from requisitos where
--             estudios feq estudios>=0';
--  consulta:='select estudios from aptitud where experiencia feq null-4 and NOT aptitud.experiencia feq UNDEFINED*6 and experiencia feq UNKNOWN/3 3 and aptitud.experiencia feq null+sqrt(experienciat) 4';
--  consulta:='select clave,requisitos.estudios from requisitos where estudios fgeq null >=0';
--  consulta:='select ciudad1,ciudad2,distancia from ciudades,aptitud where distancia is unknown or distancia is not undefined and distancia is not null or distancia is null';
--  consulta:='select aptitud.estudios e,experiencia from requisitos aptitud,aptitud tdfs';
--  consulta:='select indice from FSQL_QUERY where atributo like '||CHR(39)||'%column'||CHR(39)||'||atributo';
--  consulta:='select estudios from aptitud where estudios feq null+1 and estudios feq undefined+2and estudios feq undefined+3 <>3
--  or experiencia feq null+11 and experiencia feq undefined+22<44 and experiencia feq undefined+33 <>3';
--  consulta:='select estudios from aptitud,ciudades where experiencia feq 2 and experiencia feq 43-rowid';

--  consulta:='select CDEG(estudios) from requisitos where estudios feq $egb and (estudios feq $doctor)';
--  consulta:='select experiencia,CDEG(experiencia),estudios,CDEG(estudios) from aptitud
--             where estudios feq $egb .5 and experiencia feq $bastante .5';
--  consulta:='select experiencia,estudios from aptitud';
--  consulta:='select CDEG(experiencia) from aptitud
--  where NOT (estudios feq $egb .5 and experiencia feq [3,100] .5)';
--  consulta:='select CDEG(*) from aptitud
--  where estudios is unknown and
--        not experiencia feq $bastante <.5 or
--        not experiencia fgt $[1,2,3,4] and proft=1';-- or 23>profp1';
--  consulta:='select CDEG(*) from aptitud,requisitos
--  where experiencia feq experiencia .5e+2 or 1+experienciat+5>5-7';

--  consulta:='select cdeg(distancia),cdeg(experiencia),cdeg(estudios),cdeg(*)
--  from ciudades,aptitud
--  where (NOT distancia>50 or experiencia feq $bastante .4) and
--        distancia fgt $larga thold .33 or experiencia feq 5 <.7 and
--        estudios feq $egb .3';

--  consulta:='select CDEG(experiencia) from aptitud,requisitos
--  where experiencia feq $bastante .5 or 5||4=4';
--  consulta:='select scott.aptitud.*,scott.ciudades.*,scott.requisitos.* from requisitos,ciudades,aptitud';
--  consulta:='select * from requisitos,ciudades,aptitud where distancia feq $larga AND experiencia feq $bastante';
--  consulta:='select ciudades.*,cdeg(distancia) from ciudades where distancia feq $larga .8';
--  consulta:='select ciudades.% from ciudades where distancia feq $larga .8';

--  consulta:='select ppgg.aptitud.%, ciudades.% from aptitud,ciudades where experiencia feq $bastante .8 and estudios feq $egb or estudios feq $doctor and distancia feq $larga or aptitud.prof feq $director';
--  consulta:='select scott.aptitud.*,cdeg(scott.aptitud.estudios),cdeg(scott.aptitud.prof),cdeg(scott.aptitud.experiencia) from aptitud where experiencia feq $bastante .8';
--  consulta:='select % from aptitud,scott.ciudades where experiencia feq $bastante .8 and estudios feq $egb or estudios feq $doctor and distancia feq $larga or aptitud.prof feq $director';
--  consulta:='select % from scott.ciudades where distancia feq $larga or ciudades.distancia feq $corta';
--  consulta:='select % from aptitud,requisitos r
--             where r.estudios feq $egb or aptitud.estudios feq r.estudios .6 and (experiencia feq $bastante or r.estudios feq $egb)';
--  consulta:='select cdeg(*),cdeg(experiencia),cdeg(distancia) from aptitud,ciudades where
--experiencia feq distancia + sqrt(.5) <.7 or sqrt(4)<3 or
--experiencia feq distancia and distancia fgt $larga
--and 6<5 OR NOT distancia<300';

--  consulta:='select cdeg(distancia) from ciudades where distancia feq $corta';
--  consulta:='select % from aptitud,ciudades where experiencia feq distancia + sqrt(.5)-5 <.7 or experiencia feq distancia and distancia fgt $larga';
--  consulta:='select * from ciu';
--  consulta:='select ciudad1,distancia,round(cdeg(distancia),2) from ciudades where distancia feq $larga .25';
--  consulta:='select ciudad1,distancia,cdeg(distancia) loco from ciudades';
--  consulta:='select prof,experiencia,cdeg(experiencia)+cdeg(prof)+1 from aptitud where experiencia feq $bastante .1';
--  consulta:='select distancia,cdeg(distancia) from ciudades where ciudad1 is not null';

--  consulta:='selecT ciudad1 from aptitud,ciudades where distancia fgt experiencia and experiencia fgt experiencia and experiencia fgt distancia';
--  consulta:='select dual.dummy from sys.dual';
--  consulta:='select distinct x.experiencia x,cdeg(x.experiencia)
--,puestos.experiencia from aptitud x, puestos
--where puestos.experiencia fgt x.experiencia 0';
--  consulta:='SELECT p.* FROM puestos p';
  -- Divisin PLAYERS / SEARCH
  consulta:='SELECT distinct TEAM,CDEG(*) FROM PLAYERS P1 WHERE NOT EXISTS
  (SELECT SEARCH.* FROM SEARCH
   WHERE NOT EXISTS
     (SELECT P2.* FROM PLAYERS P2
      WHERE P2.TEAM+1=P1.TEAM and
            P2.HEIGHT  FEQ SEARCH.HEIGHT  0.5 AND
            P2.QUALITY FEQ SEARCH.QUALITY 0.5))';

--  consulta:='SELECT %
--from aptitud a,puestos p
--WHERE a.experiencia FEQ p.experiencia .1 AND
--      a.prof        FEQ p.prof .1 AND
--      a.estudios    FEQ p.estudios .1
--order by a.experiencia;';

--  consulta:='SELECT 1-cdeg(distancia) from ciudades where not distancia feq $larga <0
--order by cdeg(distancia)';

--  consulta:='SELECT experiencia, cdeg(*) from aptitud where 1=1';
-- Posicin:          10        20        30        40        50        60        70        80        90        100       110       120       130
--           123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
--  dbms_output.put_line('CONSULTA: '||consulta);
  consulta:='SELECT ciudades.*,cdeg(*)
  FROM   Ciudades
  WHERE  DISTANCIA + Distancia MGT 7';

  consulta:='SELECT IMAGENES.%, CDEG(*) FROM IMAGENES';
  Num_Errores:=fsql_pkg.fsql2sql(consulta);
  IF Num_Errores<>0 THEN
     dbms_output.put_line('- Errores encontrados: '||Num_Errores);
     FOR error IN errores LOOP
        dbms_output.put_line(error.INDICE||'  '||error.MSG_ERROR);
     END LOOP;
  ELSE
     dbms_output.put_line('***** SIN ERRORES! ***** La conversin a SQL es:');
     FOR item IN query LOOP
       dbms_output.put_line(item.atributo);
     END LOOP;
  END IF;
--NOTAS:
--  * Antes de IS no se admiten ctes.
--  * OJO!: SI SE OLVIDA EL FROM... DA UN ERROR DEMASIADO LARGO!
--EXCEPTION
--  WHEN OTHERS THEN NULL;
END;
/
